@echo off
if "%OS%" == "Windows_NT" setlocal
rem ------------------------------------------------------
rem Start script for the GeoRasterViewer
rem Environment Variable Prequisites
rem
rem   ORACLE_HOME     Oracle database installation home.
rem ------------------------------------------------------

if not "%ORACLE_HOME%" =="" goto moreCheck2
echo The ORACLE_HOME environment variable is not defined.
echo This environment variable is needed to run this program.
goto end

:moreCheck2
if exist "%ORACLE_HOME%\jdk\bin\java.exe" goto doneCheck
echo Can't find java.exe.
echo This file is needed to run this program.
goto end

:doneCheck

rem Oracle JDBC and XML parser JARs:
set JARS=%ORACLE_HOME%\lib\xmlparserv2.jar;%ORACLE_HOME%\jdbc\lib\ojdbc6.jar

rem Spatial JARS: topology, jgeometry, and utilities
set JARS=%JARS%;%ORACLE_HOME%\md\jlib\sdoapi.jar
set JARS=%JARS%;%ORACLE_HOME%\md\jlib\sdotopo.jar
set JARS=%JARS%;%ORACLE_HOME%\md\jlib\sdoutl.jar
set JARS=%JARS%;%ORACLE_HOME%\md\jlib\sdotype.jar

rem JAI jars
set JARS=%JARS%;%ORACLE_HOME%\ord\jlib\jai_core.jar
set JARS=%JARS%;%ORACLE_HOME%\ord\jlib\jai_codec.jar

rem XDB jars
set JARS=%JARS%;%ORACLE_HOME%\rdbms\jlib\xdb.jar

rem GeoRaster JAR: 
set JARS=%JARS%;%ORACLE_HOME%\md\demo\georaster\java\georaster_tools.jar


set GEORASTERVIEWER_CLASS=oracle.spatial.georaster.tools.GeoRasterTool

@echo on

rem Note: jdk1.6 and up is required to run the program.
%ORACLE_HOME%\jdk\bin\java -cp %JARS%  %GEORASTERVIEWER_CLASS% 

:end
